<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * @package direct-as-a-service
 * @subpackage controllers
 * @filesource
*//** */

require_once 'mailbox_controller.php';

/**
* API methods to manage purpose of disclosure entries for a message.
*
* Inherits mailbox validation from the mailbox controller.  Mailbox name is a required field for all actions on this controller, with the exception of messages to send or save a messagage; these actions require the sender's email address to be provided.
*
* @author Elan Jaffee <jaffee_elan@bah.com>
* @author M. Gibbs <gibbs_margaret@bah.com>
*
* @todo There's no need for this to be in its own controller when there's only one method.  This would be fine on the message_controller.
*
* @package direct-as-a-service
* @subpackage controllers
*/
class Message_disclosure_controller extends Mailbox_controller{	

	public function log_attachment_disclosure_post(){
		$required_fields = array('id','hash','purpose','ssn'); 
			
		//set variables for each optional field
		foreach($required_fields as $field){
			$$field = element($field, $this->post(), null);
			if(is_null($$field)){
				$this->missing_required_fields[] = $field;
			}
		}
		
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('send');
		$this->respond_with_error_if_mailbox_is_inactive();
		
		//check to make sure that id is valid
		if(!Message::formatted_like_an_id($id))
			$this->invalid_fields[] = 'id';
		if(!is_numeric($ssn) || strlen($ssn) != 9){	//match ssn 9 numbers (preg match is more resource-intensive than necessary, just make sure it's a number of the right length)
			$this->invalid_fields[] = 'ssn';
		}
		
		if(empty($purpose)){
			$this->invalid_fields[] = 'purpose';
		}
				
		$this->respond_with_error_if_fields_are_invalid();	
		
		$message = Message::find_one($id);
		if(!Message::is_an_entity($message) || !$message->belongs_to_mailbox($this->mailbox) || !$message->draft){
			$this->response('Message not found.', 422);
		}
		
		if(!$message->has_attachments()){
			$this->response('Message does not have attachments that require disclosure', 422);
		}
		
		//make sure that the supplied hash matches an attachment on the message
		$attachments_that_match_hash = array();
		foreach($message->attachment_files as $name => $binary_string){
			if(sha1($binary_string) == $hash)
				$attachments_that_match_hash[$name] = $binary_string;
		}
		if(empty($attachments_that_match_hash))
			$this->response('Attachment not found', 422);
		
		//make sure that the attachment actually needs disclosure
		foreach($attachments_that_match_hash as $name => $binary_string){
			if(!Attachment_disclosure::content_requires_disclosure($binary_string))
				$this->response('Attachment does not require disclosure', 422);
		}			
	
		$recipient = ''; //we'll set recipient to empty for drafts - disclosures will be set for all recipients when the message is sent
	
		//we'll switch the purpose of disclosures to being recipient-by-recipient when we send the message - it's too much work before the recipients are finalized
		$disclosure = Attachment_disclosure::update_or_create_for_message($message, compact('hash', 'purpose', 'recipient', 'ssn'));
		if(!Attachment_disclosure::is_an_entity($disclosure)) return $this->response('Unable to save log attachment disclosure', 400);						

		$this->response("Logged disclosure", 200);
	}
}	